#include "GetObject.js"
#include "GetPoint.js"

function SetPlaneOrigin( plane )
{
	var origin = plane.projectz( moi.view.getCPlane().origin );
	return moi.vectorMath.createFrame( origin, plane.xaxis, plane.yaxis );
}

function DoDimRadius()
{
    var objectpicker = moi.ui.createObjectPicker();
    objectpicker.allowCurves();
    if ( !GetObject( objectpicker ) )
        return;

	var crv = objectpicker.objects.item(0);
	if ( !crv.isPlanar )
		return;

	var pointpicker = moi.ui.createPointPicker();
	pointpicker.restrictToPlane( SetPlaneOrigin(crv.planarFrame), true );

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectPrompt' );
	moi.ui.showUI( 'ArrowPrompt' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'dimradius' );
	factory.setInput( 0, crv );
	moi.ui.bindUIToInput( 'type', 'value', factory.getInput(1) );
	moi.ui.bindUIToInput( 'AnnotationPreset', 'value', factory.getInput(4) );

	pointpicker.bindResultPt( factory.getInput(2) );

	crv.setHitTest( false );
	var res = GetPoint( pointpicker );
	crv.setHitTest( true );

    if ( !res )
		return;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'ArrowPrompt' );
	moi.ui.showUI( 'TextPrompt' );
	moi.ui.endUIUpdate();

	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(3) );
	if ( !GetPoint( pointpicker ) )
		return;

	factory.commit();
}

DoDimRadius();
